/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ui;

import com.aptana.core.util.EclipseUtil;
import com.aptana.core.util.SudoManager;
import com.aptana.ui.Messages;
import com.aptana.ui.dialogs.SudoPasswordPromptDialog;
import com.aptana.ui.util.UIUtils;
import java.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.widgets.Shell;

public class SudoUIManager {
    private static int MAX_ATTEMPTS = 3;
    private char[] validPassword = null;

    public char[] getPassword() throws CoreException {
        final IStatus[] status = new IStatus[]{Status.OK_STATUS};
        if (this.validPassword == null) {
            final SudoManager sudoMngr = new SudoManager();
            if (sudoMngr.authenticate(null)) {
                return new char[0];
            }
            UIUtils.getDisplay().syncExec(new Runnable(){

                public void run() {
                    try {
                        boolean retry;
                        int retryAttempts = 0;
                        String promptMessage = MessageFormat.format(Messages.SudoManager_MessagePrompt, EclipseUtil.getStudioPrefix());
                        do {
                            ++retryAttempts;
                            retry = false;
                            SudoPasswordPromptDialog sudoDialog = new SudoPasswordPromptDialog(new IShellProvider(){

                                public Shell getShell() {
                                    return UIUtils.getActiveShell();
                                }
                            }, promptMessage);
                            int open = sudoDialog.open();
                            if (open == 0) {
                                if (sudoMngr.authenticate(sudoDialog.getPassword())) {
                                    SudoUIManager.this.validPassword = sudoDialog.getPassword();
                                } else {
                                    retry = true;
                                }
                            } else if (open == 1) {
                                throw new CoreException((IStatus)new Status(8, "com.aptana.ui", Messages.SudoUIManager_OperationCancelledError));
                            }
                            promptMessage = Messages.Sudo_Invalid_Password_Prompt;
                        } while (retry && retryAttempts < MAX_ATTEMPTS);
                        if (SudoUIManager.this.validPassword == null && retryAttempts >= MAX_ATTEMPTS) {
                            throw new CoreException((IStatus)new Status(8, "com.aptana.ui", Messages.SudoUIManager_LoginErrorMessage));
                        }
                    }
                    catch (CoreException e) {
                        status[0] = e.getStatus();
                    }
                }
            });
        }
        if (status[0] != Status.OK_STATUS) {
            throw new CoreException(status[0]);
        }
        return this.validPassword;
    }
}

